/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.c.CirdanTheShipwrightVote;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class CirdanTheShipwrightEffect
extends OneShotEffect {
    CirdanTheShipwrightEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player secretly votes for a player, then those votes are revealed. Each player draws a card for each vote they received. Each player who received no votes may put a permanent card from their hand onto the battlefield";
    }

    private CirdanTheShipwrightEffect(CirdanTheShipwrightEffect effect) {
        super((OneShotEffect)effect);
    }

    public CirdanTheShipwrightEffect copy() {
        return new CirdanTheShipwrightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CirdanTheShipwrightVote vote = new CirdanTheShipwrightVote();
        vote.doVotes(source, game);
        Map<UUID, Integer> playerMap = vote.getVotesPerPlayer(game);
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            int amount = playerMap.getOrDefault(playerId, 0);
            if (player == null || amount <= 0) continue;
            player.drawCards(amount, source, game);
        }
        HashMap<Player, Card> voteless = new HashMap<Player, Card>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || playerMap.containsKey(playerId)) continue;
            TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)StaticFilters.FILTER_CARD_PERMANENT);
            target.withChooseHint("to put onto the battlefield");
            player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
            voteless.put(player, game.getCard(target.getFirstTarget()));
        }
        for (Map.Entry entry : voteless.entrySet()) {
            if (entry.getValue() == null) continue;
            ((Player)entry.getKey()).moveCards((Card)entry.getValue(), Zone.BATTLEFIELD, source, game);
        }
        return true;
    }
}

