/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.c.CityInABottle;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CityInABottleSacrificeEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("other nontoken permanents with a name originally printed in the Arabian Nights expansion");

    CityInABottleSacrificeEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "their controllers sacrifice them";
    }

    private CityInABottleSacrificeEffect(CityInABottleSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public CityInABottleSacrificeEffect copy() {
        return new CityInABottleSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            permanent.sacrifice(source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
        filter.add(Predicates.or(CityInABottle.ARABIAN_NIGHTS_CARD_NAME_PREDICATES));
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

