/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.cards.c.ClarionUltimatumTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetControlledPermanent;

class ClarionUltimatumEffect
extends OneShotEffect {
    ClarionUltimatumEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Choose five permanents you control. For each of those permanents, you may search your library for a card with the same name as that permanent. Put those cards onto the battlefield tapped, then shuffle";
    }

    private ClarionUltimatumEffect(ClarionUltimatumEffect effect) {
        super((OneShotEffect)effect);
    }

    public ClarionUltimatumEffect copy() {
        return new ClarionUltimatumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int permCount = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT, source.getControllerId(), source, game);
        TargetControlledPermanent targetPermanent = new TargetControlledPermanent(Math.max(permCount, 5));
        targetPermanent.withNotTarget(true);
        player.choose(this.outcome, (Target)targetPermanent, source, game);
        Set<String> names = targetPermanent.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).map(MageObject::getName).collect(Collectors.toSet());
        ClarionUltimatumTarget targetCardInLibrary = new ClarionUltimatumTarget(names);
        player.searchLibrary((TargetCardInLibrary)targetCardInLibrary, source, game);
        CardsImpl cards = new CardsImpl((Collection)targetCardInLibrary.getTargets());
        player.moveCards(cards.getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        player.shuffleLibrary(source, game);
        return true;
    }
}

