/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class ClarionUltimatumTarget
extends TargetCardInLibrary {
    private final Map<String, Integer> nameMap = new HashMap<String, Integer>();

    ClarionUltimatumTarget(Set<String> names) {
        super(0, names.size(), ClarionUltimatumTarget.makeFilter(names));
        this.populateNameMap(names);
    }

    private ClarionUltimatumTarget(ClarionUltimatumTarget target) {
        super((TargetCardInLibrary)target);
        this.nameMap.putAll(target.nameMap);
    }

    public ClarionUltimatumTarget copy() {
        return new ClarionUltimatumTarget(this);
    }

    private static FilterCard makeFilter(Set<String> names) {
        FilterCard filter = new FilterCard();
        filter.add(Predicates.or((Iterable)names.stream().map(name -> new NamePredicate(name)).collect(Collectors.toSet())));
        return filter;
    }

    private void populateNameMap(Set<String> names) {
        names.stream().forEach(name -> this.nameMap.compute((String)name, CardUtil::setOrIncrementValue));
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        HashMap alreadyChosen = new HashMap();
        this.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).map(MageObject::getName).forEach(name -> alreadyChosen.compute(name, CardUtil::setOrIncrementValue));
        return this.nameMap.getOrDefault(card.getName(), 0) > alreadyChosen.getOrDefault(card.getName(), 0);
    }
}

