/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CardsInControllerGraveyardCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.AbilityWord;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CleansingMeditationEffect
extends OneShotEffect {
    CleansingMeditationEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all enchantments.<br>" + AbilityWord.THRESHOLD.formatWord() + "If seven or more cards are in your graveyard, instead destroy all enchantments, then return all cards in your graveyard destroyed this way to the battlefield.";
    }

    private CleansingMeditationEffect(CleansingMeditationEffect effect) {
        super((OneShotEffect)effect);
    }

    public CleansingMeditationEffect copy() {
        return new CleansingMeditationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CardsImpl cardsToBattlefield = new CardsImpl();
        boolean threshold = false;
        CardsInControllerGraveyardCount c = new CardsInControllerGraveyardCount();
        int numCards = c.calculate(game, source, (Effect)this);
        if (numCards >= 7) {
            threshold = true;
        }
        Player controller = game.getPlayer(source.getControllerId());
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_ENCHANTMENT, source.getControllerId(), source, game)) {
            if (permanent == null || !permanent.destroy(source, game, false) || !threshold || controller == null || !permanent.isOwnedBy(controller.getId())) continue;
            cardsToBattlefield.add((Card)permanent);
        }
        if (threshold && controller != null) {
            controller.moveCards((Cards)cardsToBattlefield, Zone.BATTLEFIELD, source, game);
        }
        return true;
    }
}

