/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Library;
import mage.players.Player;

class ClearTheLandEffect
extends OneShotEffect {
    public ClearTheLandEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player reveals the top five cards of their library, puts all land cards revealed this way onto the battlefield tapped, and exiles the rest.";
    }

    private ClearTheLandEffect(ClearTheLandEffect effect) {
        super((OneShotEffect)effect);
    }

    public ClearTheLandEffect copy() {
        return new ClearTheLandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean tapped = true;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                Library library = player.getLibrary();
                CardsImpl cardsToReveal = new CardsImpl();
                cardsToReveal.addAllCards((Collection)library.getTopCards(game, 5));
                if (cardsToReveal.isEmpty()) continue;
                player.revealCards(source, "Revealed cards for " + player.getName(), (Cards)cardsToReveal, game);
                CardsImpl cardsToPutOnBattlefield = new CardsImpl();
                CardsImpl cardsToExile = new CardsImpl();
                for (Card card : cardsToReveal.getCards(game)) {
                    if (card.isLand(game)) {
                        cardsToPutOnBattlefield.add(card);
                        continue;
                    }
                    cardsToExile.add(card);
                }
                player.moveCards(cardsToPutOnBattlefield.getCards(game), Zone.BATTLEFIELD, source, game, tapped, false, true, null);
                player.moveCards(cardsToExile.getCards(game), Zone.EXILED, source, game);
            }
            return true;
        }
        return false;
    }
}

