/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ClearTheMindEffect
extends OneShotEffect {
    ClearTheMindEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player shuffles their graveyard into their library";
    }

    private ClearTheMindEffect(ClearTheMindEffect effect) {
        super((OneShotEffect)effect);
    }

    public ClearTheMindEffect copy() {
        return new ClearTheMindEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        player.putCardsOnBottomOfLibrary((Cards)new CardsImpl(player.getGraveyard().getCards(game)), game, source, false);
        player.shuffleLibrary(source, game);
        return true;
    }
}

