/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.condition.common.FerociousCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class ClearTheStageEffect
extends OneShotEffect {
    ClearTheStageEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target creature gets -3/-3 until end of turn. If you control a creature with power 4 or greater, you may return up to one target creature card from your graveyard to your hand.";
    }

    private ClearTheStageEffect(ClearTheStageEffect effect) {
        super((OneShotEffect)effect);
    }

    public ClearTheStageEffect copy() {
        return new ClearTheStageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        game.addEffect((ContinuousEffect)new BoostTargetEffect(-3, -3), source);
        if (!FerociousCondition.instance.apply(game, source)) {
            return true;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !player.chooseUse(Outcome.Benefit, "Return a creature card from your graveyard to your hand?", source, game)) {
            return false;
        }
        Card card = game.getCard(((Target)source.getTargets().get(1)).getFirstTarget());
        if (card == null) {
            return false;
        }
        return player.moveCards(card, Zone.HAND, source, game);
    }
}

