/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.cards.c.CloakOfConfusionEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CloakOfConfusionTriggeredAbility
extends TriggeredAbilityImpl {
    CloakOfConfusionTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DiscardTargetEffect(1, true), false);
        this.addEffect((Effect)new CloakOfConfusionEffect());
    }

    private CloakOfConfusionTriggeredAbility(CloakOfConfusionTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CloakOfConfusionTriggeredAbility copy() {
        return new CloakOfConfusionTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNBLOCKED_ATTACKER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent aura = this.getSourcePermanentOrLKI(game);
        if (aura != null && event.getTargetId().equals(aura.getAttachedTo())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(game.getCombat().getDefendingPlayerId(aura.getAttachedTo(), game)));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever enchanted creature attacks and isn't blocked, you may have it assign no combat damage this turn. If you do, defending player discards a card at random";
    }
}

