/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CloneLegionEffect
extends OneShotEffect {
    CloneLegionEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each creature target player controls, create a token that's a copy of that creature";
    }

    private CloneLegionEffect(CloneLegionEffect effect) {
        super((OneShotEffect)effect);
    }

    public CloneLegionEffect copy() {
        return new CloneLegionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && targetPlayer != null) {
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, targetPlayer.getId(), game)) {
                if (permanent == null) continue;
                CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

