/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class CloneShellEffect
extends OneShotEffect {
    protected static FilterCard filter1 = new FilterCard("card to exile face down");
    protected static FilterCard filter2 = new FilterCard("card to put on the bottom of your library");

    public CloneShellEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top four cards of your library, exile one face down, then put the rest on the bottom of your library in any order";
    }

    private CloneShellEffect(CloneShellEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 4));
        if (!cards.isEmpty()) {
            TargetCard target1 = new TargetCard(Zone.LIBRARY, filter1);
            if (controller.choose(Outcome.Benefit, (Cards)cards, target1, source, game)) {
                Card card = cards.get(target1.getFirstTarget(), game);
                if (card != null) {
                    cards.remove(card);
                    controller.moveCardsToExile(card, source, game, false, CardUtil.getCardExileZoneId((Game)game, (Ability)source), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, (String)"(Imprint)"));
                    card.setFaceDown(true, game);
                    Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
                    if (permanent != null) {
                        permanent.imprint(card.getId(), game);
                    }
                }
                target1.clearChosen();
            }
            controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
        }
        return true;
    }

    public CloneShellEffect copy() {
        return new CloneShellEffect(this);
    }
}

