/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class ClosingStatementEffect
extends OneShotEffect {
    ClosingStatementEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a +1/+1 counter on up to one target creature you control";
    }

    private ClosingStatementEffect(ClosingStatementEffect effect) {
        super((OneShotEffect)effect);
    }

    public ClosingStatementEffect copy() {
        return new ClosingStatementEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Target target = source.getTargets().stream().filter(t -> t.getTargetTag() == 2).findFirst().orElseThrow(() -> new IllegalStateException("Expected to find target with tag 2 but none exists"));
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent != null) {
            return permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
        }
        return true;
    }
}

