/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.token.ClownRobotToken;
import mage.players.Player;

class ClowningAroundEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.ROBOT);

    ClowningAroundEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then roll a six-sided die. If the result is equal to or less than the number of Robots you control, create a 1/1 white Clown Robot artifact creature token";
    }

    private ClowningAroundEffect(ClowningAroundEffect effect) {
        super((OneShotEffect)effect);
    }

    public ClowningAroundEffect copy() {
        return new ClowningAroundEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int roll = player.rollDice(this.outcome, source, game, 6);
        if (roll <= game.getBattlefield().count(filter, source.getControllerId(), source, game)) {
            new ClownRobotToken().putOntoBattlefield(1, game, source);
        }
        return true;
    }
}

