/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CoalitionRelicEffect
extends OneShotEffect {
    CoalitionRelicEffect() {
        super(Outcome.PutManaInPool);
        this.staticText = "remove all charge counters from {this}. Add one mana of any color for each charge counter removed this way";
    }

    private CoalitionRelicEffect(CoalitionRelicEffect effect) {
        super((OneShotEffect)effect);
    }

    public CoalitionRelicEffect copy() {
        return new CoalitionRelicEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Player player = game.getPlayer(source.getControllerId());
        if (sourcePermanent != null && player != null) {
            int amountRemoved = sourcePermanent.removeAllCounters(CounterType.CHARGE.getName(), source, game);
            Mana mana = new Mana();
            ChoiceColor choice = new ChoiceColor();
            for (int i = 0; i < amountRemoved; ++i) {
                if (!player.choose(this.outcome, (Choice)choice, game)) {
                    return false;
                }
                choice.increaseMana(mana);
                choice.clearChoice();
            }
            player.getManaPool().addMana(mana, game, source);
            return true;
        }
        return false;
    }
}

