/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.List;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CoatOfArmsEffect
extends ContinuousEffectImpl {
    CoatOfArmsEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Each creature gets +1/+1 for each other creature on the battlefield that shares at least one creature type with it";
    }

    private CoatOfArmsEffect(CoatOfArmsEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public CoatOfArmsEffect copy() {
        return new CoatOfArmsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game);
        for (Permanent permanent : permanents) {
            int amount = this.getAmount(permanents, permanent, game);
            permanent.addPower(amount);
            permanent.addToughness(amount);
        }
        return true;
    }

    private int getAmount(List<Permanent> permanents, Permanent target, Game game) {
        int amount = 0;
        for (Permanent permanent : permanents) {
            if (permanent.getId().equals(target.getId()) || !permanent.shareCreatureTypes(game, (MageObject)target)) continue;
            ++amount;
        }
        return amount;
    }
}

