/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CocoonEffect
extends OneShotEffect {
    CocoonEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "remove a pupa counter from {this}. If you can't, sacrifice it, put a +1/+1 counter on enchanted creature, and that creature gains flying";
    }

    private CocoonEffect(CocoonEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent != null) {
            int amount = permanent.getCounters(game).getCount(CounterType.PUPA);
            if (amount > 0) {
                permanent.removeCounters(CounterType.PUPA.createInstance(), source, game);
            } else {
                Permanent enchantedPermanent = game.getPermanent(permanent.getAttachedTo());
                permanent.sacrifice(source, game);
                if (enchantedPermanent != null) {
                    AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.P1P1.createInstance());
                    effect.setTargetPointer((TargetPointer)new FixedTarget(enchantedPermanent, game));
                    effect.apply(game, source);
                    GainAbilityTargetEffect effect2 = new GainAbilityTargetEffect((Ability)FlyingAbility.getInstance(), Duration.Custom);
                    effect2.setTargetPointer((TargetPointer)new FixedTarget(enchantedPermanent, game));
                    game.addEffect((ContinuousEffect)effect2, source);
                }
            }
            return true;
        }
        return false;
    }

    public CocoonEffect copy() {
        return new CocoonEffect(this);
    }
}

