/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class CodespellClericWatcher
extends Watcher {
    private final Map<UUID, List<MageObjectReference>> spellMap = new HashMap<UUID, List<MageObjectReference>>();
    private static final List<MageObjectReference> emptyList = Collections.unmodifiableList(new ArrayList());

    CodespellClericWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST) {
            this.spellMap.computeIfAbsent(event.getPlayerId(), x -> new ArrayList()).add(new MageObjectReference(event.getSourceId(), game));
        }
    }

    public void reset() {
        super.reset();
        this.spellMap.clear();
    }

    boolean checkSpell(Ability source, Game game) {
        Permanent permanent = (Permanent)((Effect)source.getEffects().get(0)).getValue("permanentEnteredBattlefield");
        if (permanent == null) {
            return false;
        }
        int index = 0;
        for (MageObjectReference mor : this.spellMap.getOrDefault(source.getControllerId(), emptyList)) {
            ++index;
            if (mor.getSourceId() != permanent.getId() || mor.getZoneChangeCounter() + 1 != permanent.getZoneChangeCounter(game)) continue;
            return index == 2;
        }
        return false;
    }
}

