/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CoercivePortalEffect
extends OneShotEffect {
    CoercivePortalEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player votes for carnage or homage. If carnage gets more votes, sacrifice {this} and destroy all nonland permanents. If homage gets more votes or the vote is tied, draw a card";
    }

    private CoercivePortalEffect(CoercivePortalEffect effect) {
        super((OneShotEffect)effect);
    }

    public CoercivePortalEffect copy() {
        return new CoercivePortalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TwoChoiceVote vote = new TwoChoiceVote("Carnage (sacrifice and destroy)", "Homage (draw a card)", Outcome.Detriment);
        vote.doVotes(source, game);
        int carnageCount = vote.getVoteCount((Object)true);
        int homageCount = vote.getVoteCount((Object)false);
        if (carnageCount > homageCount) {
            Permanent permanent = source.getSourcePermanentIfItStillExists(game);
            if (permanent != null && permanent.isControlledBy(source.getControllerId())) {
                permanent.sacrifice(source, game);
            }
            new DestroyAllEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND).apply(game, source);
        } else {
            Player player = game.getPlayer(source.getControllerId());
            if (player != null) {
                player.drawCards(1, source, game);
            }
        }
        return true;
    }
}

