/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.condition.common.GiftWasPromisedCondition;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class CoilingRebirthEffect
extends OneShotEffect {
    CoilingRebirthEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Return target creature card from your graveyard to the battlefield. Then if the gift was promised and that creature isn't legendary, create a token that's a copy of that creature, except it's 1/1.";
    }

    private CoilingRebirthEffect(CoilingRebirthEffect effect) {
        super((OneShotEffect)effect);
    }

    public CoilingRebirthEffect copy() {
        return new CoilingRebirthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller == null || card == null || game.getState().getZone(card.getId()) != Zone.GRAVEYARD) {
            return false;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        if (GiftWasPromisedCondition.TRUE.apply(game, source)) {
            game.processAction();
            Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
            if (permanent != null && !permanent.isLegendary(game)) {
                CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, null, false, 1, false, false, null, 1, 1, false);
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                effect.apply(game, source);
            }
        }
        return true;
    }
}

