/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ColfenorsUrnEffect
extends OneShotEffect {
    ColfenorsUrnEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "sacrifice it. If you do, return those cards to the battlefield under their owner's control";
    }

    private ColfenorsUrnEffect(ColfenorsUrnEffect effect) {
        super((OneShotEffect)effect);
    }

    public ColfenorsUrnEffect copy() {
        return new ColfenorsUrnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (controller != null && permanent != null) {
            UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
            ExileZone exile = game.getExile().getExileZone(exileId);
            if (permanent.sacrifice(source, game)) {
                controller.moveCards(exile.getCards(game), Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

