/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.keyword.EscalateAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.c.CollectiveEffortEffect;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.FilterPlayer;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.target.TargetPermanent;
import mage.target.TargetPlayer;
import mage.target.common.TargetEnchantmentPermanent;

public final class CollectiveEffort
extends CardImpl {
    private static final FilterCreaturePermanent filterDestroyCreature = new FilterCreaturePermanent("creature with power 4 or greater");
    private static final FilterPlayer filterPlayer = new FilterPlayer("player whose creatures get +1/+1 counters");

    public CollectiveEffort(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{1}{W}{W}");
        this.addAbility((Ability)new EscalateAbility((Cost)new TapTargetCost((FilterControlledPermanent)StaticFilters.FILTER_CONTROLLED_UNTAPPED_CREATURE)));
        this.getSpellAbility().getModes().setMinModes(1);
        this.getSpellAbility().getModes().setMaxModes(3);
        this.getSpellAbility().addEffect((Effect)new DestroyTargetEffect());
        this.getSpellAbility().addTarget(new TargetPermanent((FilterPermanent)filterDestroyCreature).withChooseHint("destroy"));
        Object effect = new DestroyTargetEffect();
        effect.setText("Destroy target enchantment");
        Mode mode = new Mode((Effect)effect);
        mode.addTarget(new TargetEnchantmentPermanent().withChooseHint("destroy"));
        this.getSpellAbility().addMode(mode);
        effect = new CollectiveEffortEffect();
        effect.setText("Put a +1/+1 counter on each creature target player controls");
        mode = new Mode((Effect)effect);
        mode.addTarget(new TargetPlayer(1, 1, false, filterPlayer).withChooseHint("put +1/+1 counter on each creature"));
        this.getSpellAbility().addMode(mode);
    }

    private CollectiveEffort(CollectiveEffort card) {
        super((CardImpl)card);
    }

    public CollectiveEffort copy() {
        return new CollectiveEffort(this);
    }

    static {
        filterDestroyCreature.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 3));
    }
}

