/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.common.DomainValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.combat.CantAttackYouUnlessPayAllEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class CollectiveRestraintPayManaToAttackAllEffect
extends CantAttackYouUnlessPayAllEffect {
    CollectiveRestraintPayManaToAttackAllEffect() {
        super(Duration.WhileOnBattlefield, (Cost)new ManaCostsImpl("{X}"));
        this.staticText = "Creatures can't attack you unless their controller pays {X} for each creature they control that's attacking you, where X is the number of basic land types among lands you control.";
    }

    private CollectiveRestraintPayManaToAttackAllEffect(CollectiveRestraintPayManaToAttackAllEffect effect) {
        super((CantAttackYouUnlessPayAllEffect)effect);
    }

    public ManaCosts getManaCostToPay(GameEvent event, Ability source, Game game) {
        int domainValue = DomainValue.REGULAR.calculate(game, source, (Effect)this);
        if (domainValue > 0) {
            return new ManaCostsImpl("{" + domainValue + '}');
        }
        return null;
    }

    public CollectiveRestraintPayManaToAttackAllEffect copy() {
        return new CollectiveRestraintPayManaToAttackAllEffect(this);
    }
}

