/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.ManaUtil;

class CollectiveVoyageEffect
extends OneShotEffect {
    CollectiveVoyageEffect() {
        super(Outcome.Detriment);
        this.staticText = "<i>Join forces</i> &mdash; Starting with you, each player may pay any amount of mana. Each player searches their library for up to X basic land cards, where X is the total amount of mana paid this way, puts them onto the battlefield tapped, then shuffles";
    }

    private CollectiveVoyageEffect(CollectiveVoyageEffect effect) {
        super((OneShotEffect)effect);
    }

    public CollectiveVoyageEffect copy() {
        return new CollectiveVoyageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        HashSet toBattlefield = new HashSet();
        if (controller != null) {
            Player player;
            int xSum = 0;
            xSum += ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Collective Voyage", (Player)controller, (Ability)source, (Game)game);
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                if (Objects.equals(playerId, controller.getId()) || (player = game.getPlayer(playerId)) == null) continue;
                xSum += ManaUtil.playerPaysXGenericMana((boolean)false, (String)"Collective Voyage", (Player)player, (Ability)source, (Game)game);
            }
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                TargetCardInLibrary target;
                player = game.getPlayer(playerId);
                if (player == null || xSum == 0 || !player.searchLibrary(target = new TargetCardInLibrary(0, xSum, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND), source, game)) continue;
                toBattlefield.addAll(new CardsImpl((Collection)target.getTargets()).getCards(game));
            }
            controller.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game, true, false, true, null);
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                player.shuffleLibrary(source, game);
            }
            controller.resetStoredBookmark(game);
            return true;
        }
        return false;
    }
}

