/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.PermanentToken;
import mage.players.Player;

class CollisionOfRealmsEffect
extends OneShotEffect {
    CollisionOfRealmsEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player shuffles all creatures they own into their library. Each player who shuffled a nontoken creature into their library this way reveals cards from the top of their library until they reveal a creature card, then puts that card onto the battlefield and the rest on the bottom of their library in a random order";
    }

    private CollisionOfRealmsEffect(CollisionOfRealmsEffect effect) {
        super((OneShotEffect)effect);
    }

    public CollisionOfRealmsEffect copy() {
        return new CollisionOfRealmsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, playerId, game);
            boolean hasNonToken = permanents.stream().filter(permanent -> !(permanent instanceof PermanentToken)).anyMatch(permanent -> permanent.isCreature(game));
            player.putCardsOnBottomOfLibrary((Cards)new CardsImpl(permanents), game, source, false);
            player.shuffleLibrary(source, game);
            if (!hasNonToken) continue;
            players.add(player);
        }
        for (Player player : players) {
            CardsImpl cards = new CardsImpl();
            Card creature = CollisionOfRealmsEffect.revealUntilCreature((Cards)cards, player, game);
            player.revealCards(source, (Cards)cards, game);
            if (creature != null) {
                player.moveCards(creature, Zone.BATTLEFIELD, source, game);
            }
            cards.retainZone(Zone.LIBRARY, game);
            player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        return true;
    }

    private static Card revealUntilCreature(Cards cards, Player player, Game game) {
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (!card.isCreature(game)) continue;
            return card;
        }
        return null;
    }
}

