/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.InklingToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CombatCalligrapherTriggeredAbility
extends TriggeredAbilityImpl {
    CombatCalligrapherTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenTargetEffect((Token)new InklingToken(), (DynamicValue)StaticValue.get((int)1), true, true), false);
    }

    private CombatCalligrapherTriggeredAbility(CombatCalligrapherTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CombatCalligrapherTriggeredAbility copy() {
        return new CombatCalligrapherTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DEFENDER_ATTACKED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player attacker = game.getPlayer(event.getPlayerId());
        Player defender = game.getPlayer(event.getTargetId());
        if (attacker == null || defender == null) {
            return false;
        }
        if (!game.getOpponents(this.getControllerId()).contains(attacker.getId()) && attacker.getId() != this.getControllerId() || !game.getOpponents(this.getControllerId()).contains(defender.getId())) {
            return false;
        }
        this.getEffects().setValue("playerToAttack", (Object)defender.getId());
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(attacker.getId()));
        return true;
    }

    public String getRule() {
        return "Whenever a player attacks one of your opponents, that attacking player creates a tapped 2/1 white and black Inkling creature token with flying that's attacking that opponent.";
    }
}

