/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class CommanderLiaraPortyrCostEffect
extends CostModificationEffectImpl {
    CommanderLiaraPortyrCostEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "spells you cast from exile this turn cost {X} less to cast, where X is the number of players being attacked";
    }

    private CommanderLiaraPortyrCostEffect(CommanderLiaraPortyrCostEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public CommanderLiaraPortyrCostEffect copy() {
        return new CommanderLiaraPortyrCostEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Optional.ofNullable((Integer)this.getValue("number_defending_players")).ifPresent(i -> CardUtil.reduceCost((Ability)abilityToModify, (int)1));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return Optional.ofNullable(abilityToModify).map(Ability::getSourceId).map(arg_0 -> ((Game)game).getSpell(arg_0)).map(Spell::getFromZone).filter(arg_0 -> ((Zone)Zone.EXILED).match(arg_0)).isPresent();
    }
}

