/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.hint.Hint;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.CommanderPlaysCountWatcher;

enum CommandersInsightHint implements Hint
{
    instance;


    public String getText(Game game, Ability ability) {
        CommanderPlaysCountWatcher watcher = (CommanderPlaysCountWatcher)game.getState().getWatcher(CommanderPlaysCountWatcher.class);
        if (watcher == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("Commander cast counts &mdash; ");
        boolean flag = false;
        for (UUID playerId : game.getState().getPlayersInRange(ability.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            if (flag) {
                sb.append(',').append(' ');
            }
            flag = true;
            sb.append(player.getName());
            sb.append(": ");
            sb.append(watcher.getPlayerCount(playerId));
        }
        return sb.toString();
    }

    public CommandersInsightHint copy() {
        return instance;
    }
}

