/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.common.CanBeYourCommanderAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPlaneswalkerPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.permanent.token.CommodoreGuffToken;
import mage.game.permanent.token.Token;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class CommodoreGuff
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledPlaneswalkerPermanent("another target planeswalker you control");
    private static final DynamicValue xValue;
    private static final Hint hint;

    public CommodoreGuff(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{1}{U}{R}{W}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.GUFF);
        this.setStartingLoyalty(5);
        BeginningOfEndStepTriggeredAbility ability = new BeginningOfEndStepTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.LOYALTY.createInstance()));
        ability.addTarget((Target)new TargetPermanent(filter));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new LoyaltyAbility((Effect)new CreateTokenEffect((Token)new CommodoreGuffToken()), 1));
        ability = new LoyaltyAbility((Effect)new DrawCardSourceControllerEffect(xValue).setText("you draw X cards"), -3);
        ability.addEffect((Effect)new DamagePlayersEffect(Outcome.Damage, xValue, TargetController.OPPONENT).concatBy("and"));
        this.addAbility(ability.addHint(hint));
        this.addAbility((Ability)CanBeYourCommanderAbility.getInstance());
    }

    private CommodoreGuff(CommodoreGuff card) {
        super((CardImpl)card);
    }

    public CommodoreGuff copy() {
        return new CommodoreGuff(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        xValue = new PermanentsOnBattlefieldCount((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_PLANESWALKER);
        hint = new ValueHint("Planeswalkers you control", xValue);
    }
}

