/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class CompulsiveResearchDiscardEffect
extends OneShotEffect {
    CompulsiveResearchDiscardEffect() {
        super(Outcome.Discard);
        this.staticText = "Then that player discards two cards unless they discard a land card";
    }

    private CompulsiveResearchDiscardEffect(CompulsiveResearchDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public CompulsiveResearchDiscardEffect copy() {
        return new CompulsiveResearchDiscardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer == null || targetPlayer.getHand().isEmpty()) {
            return false;
        }
        if (targetPlayer.getHand().count((FilterCard)StaticFilters.FILTER_CARD_LAND, game) < 1 || !targetPlayer.chooseUse(this.outcome, "Discard a land card?", source, game)) {
            return !targetPlayer.discard(2, false, false, source, game).isEmpty();
        }
        TargetDiscard target = new TargetDiscard((FilterCard)StaticFilters.FILTER_CARD_LAND_A, targetPlayer.getId());
        targetPlayer.choose(Outcome.Discard, (Target)target, source, game);
        Card card = targetPlayer.getHand().get(target.getFirstTarget(), game);
        if (card != null && targetPlayer.discard(card, false, source, game)) {
            return true;
        }
        return !targetPlayer.discard(2, false, false, source, game).isEmpty();
    }
}

