/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FearAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.LandwalkAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ConcertedEffortEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filterFlying = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterFear = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterFirstStrike = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterDoubleStrike = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterLandwalk = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterProtection = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterTrample = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterVigilance = new FilterControlledCreaturePermanent();
    private static final FilterControlledCreaturePermanent filterCreatures = new FilterControlledCreaturePermanent();

    ConcertedEffortEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "creatures you control gain flying until end of turn if a creature you control has flying. The same is true for fear, first strike, double strike, landwalk, protection, trample, and vigilance";
    }

    private ConcertedEffortEffect(ConcertedEffortEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConcertedEffortEffect copy() {
        return new ConcertedEffortEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (game.getBattlefield().contains((FilterPermanent)filterFlying, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().contains((FilterPermanent)filterFear, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)FearAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().contains((FilterPermanent)filterFirstStrike, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().contains((FilterPermanent)filterDoubleStrike, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)DoubleStrikeAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filterLandwalk, source.getControllerId(), game)) {
            for (Ability ability : permanent.getAbilities(game)) {
                if (!(ability instanceof LandwalkAbility)) continue;
                game.addEffect((ContinuousEffect)new GainAbilityControlledEffect(ability, Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
            }
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filterProtection, source.getControllerId(), game)) {
            for (Ability ability : permanent.getAbilities(game)) {
                if (!(ability instanceof ProtectionAbility)) continue;
                game.addEffect((ContinuousEffect)new GainAbilityControlledEffect(ability, Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
            }
        }
        if (game.getBattlefield().contains((FilterPermanent)filterTrample, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        if (game.getBattlefield().contains((FilterPermanent)filterVigilance, source, game, 1)) {
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)VigilanceAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filterCreatures), source);
        }
        return true;
    }

    static {
        filterFlying.add((Predicate)new AbilityPredicate(FlyingAbility.class));
        filterFear.add((Predicate)new AbilityPredicate(FearAbility.class));
        filterFirstStrike.add((Predicate)new AbilityPredicate(FirstStrikeAbility.class));
        filterDoubleStrike.add((Predicate)new AbilityPredicate(DoubleStrikeAbility.class));
        filterLandwalk.add((Predicate)new AbilityPredicate(LandwalkAbility.class));
        filterProtection.add((Predicate)new AbilityPredicate(ProtectionAbility.class));
        filterTrample.add((Predicate)new AbilityPredicate(TrampleAbility.class));
        filterVigilance.add((Predicate)new AbilityPredicate(VigilanceAbility.class));
    }
}

