/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CastSourceTriggeredAbility;
import mage.abilities.effects.common.cost.SpellsCostReductionControllerEffect;
import mage.abilities.effects.common.search.SearchLibraryPutOnLibraryEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.c.ConduitOfRuinWatcher;
import mage.cards.c.FirstCastCreatureSpellPredicate;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorlessPredicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.target.common.TargetCardInLibrary;

public final class ConduitOfRuin
extends CardImpl {
    private static final FilterCreatureCard filter = new FilterCreatureCard("a colorless creature card with mana value 7 or greater");
    private static final FilterCreatureCard filterCost = new FilterCreatureCard("the first creature spell you cast each turn");

    public ConduitOfRuin(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{6}");
        this.subtype.add((Object)SubType.ELDRAZI);
        this.power = new MageInt(5);
        this.toughness = new MageInt(5);
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)filter);
        this.addAbility((Ability)new CastSourceTriggeredAbility((Effect)new SearchLibraryPutOnLibraryEffect(target, true), true));
        SpellsCostReductionControllerEffect effect = new SpellsCostReductionControllerEffect((FilterCard)filterCost, 2);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)effect), new ConduitOfRuinWatcher());
    }

    private ConduitOfRuin(ConduitOfRuin card) {
        super((CardImpl)card);
    }

    public ConduitOfRuin copy() {
        return new ConduitOfRuin(this);
    }

    static {
        filter.add((Predicate)ColorlessPredicate.instance);
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.MORE_THAN, 6));
        filterCost.add((ObjectSourcePlayerPredicate)new FirstCastCreatureSpellPredicate());
    }
}

