/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Optional;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ConformerShurikenEffect
extends OneShotEffect {
    ConformerShurikenEffect() {
        super(Outcome.Benefit);
        this.staticText = "If that creature has greater power than this creature, put a number of +1/+1 counters on this creature equal to the difference";
    }

    private ConformerShurikenEffect(ConformerShurikenEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConformerShurikenEffect copy() {
        return new ConformerShurikenEffect(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) return false;
        if (!Optional.ofNullable(this.getTargetPointer().getFirst(game, source)).map(arg_0 -> ((Game)game).getPermanent(arg_0)).map(MageObject::getPower).map(MageInt::getValue).map(targetsPower -> targetsPower - permanent.getPower().getValue()).filter(x -> x > 0 && permanent.addCounters(CounterType.P1P1.createInstance(x.intValue()), source, game)).isPresent()) return false;
        return true;
    }
}

