/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class ConfrontThePastLoyaltyEffect
extends OneShotEffect {
    ConfrontThePastLoyaltyEffect() {
        super(Outcome.Benefit);
        this.staticText = "remove twice X loyalty counters from target planeswalker an opponent controls";
    }

    private ConfrontThePastLoyaltyEffect(ConfrontThePastLoyaltyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConfrontThePastLoyaltyEffect copy() {
        return new ConfrontThePastLoyaltyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        Permanent target = game.getPermanent(source.getFirstTarget());
        target.removeCounters(CounterType.LOYALTY.createInstance(xValue * 2), source, game);
        return true;
    }
}

