/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class CongregationAtDawnEffect
extends OneShotEffect {
    private static final String textTop = "card to put on your library (last chosen will be on top)";

    public CongregationAtDawnEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for up to three creature cards, reveal them, then shuffle and put those cards on top in any order";
    }

    private CongregationAtDawnEffect(CongregationAtDawnEffect effect) {
        super((OneShotEffect)effect);
    }

    public CongregationAtDawnEffect copy() {
        return new CongregationAtDawnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInLibrary target;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null && controller.searchLibrary(target = new TargetCardInLibrary(0, 3, (FilterCard)new FilterCreatureCard("creature cards")), source, game)) {
            if (!target.getTargets().isEmpty()) {
                Card card;
                CardsImpl revealed = new CardsImpl();
                for (UUID cardId : target.getTargets()) {
                    Card card2 = controller.getLibrary().getCard(cardId, game);
                    revealed.add(card2);
                }
                controller.revealCards(sourceObject.getName(), (Cards)revealed, game);
                controller.shuffleLibrary(source, game);
                TargetCard targetToLib = new TargetCard(Zone.LIBRARY, new FilterCard(textTop));
                while (revealed.size() > 1 && controller.canRespond()) {
                    controller.choose(Outcome.Neutral, (Cards)revealed, targetToLib, source, game);
                    card = revealed.get(targetToLib.getFirstTarget(), game);
                    if (card != null) {
                        revealed.remove(card);
                        controller.moveCardToLibraryWithInfo(card, source, game, Zone.LIBRARY, true, false);
                    }
                    targetToLib.clearChosen();
                }
                if (revealed.size() == 1) {
                    card = revealed.get((UUID)revealed.iterator().next(), game);
                    controller.moveCardToLibraryWithInfo(card, source, game, Zone.LIBRARY, true, false);
                }
            }
            return true;
        }
        return false;
    }
}

