/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ConquerorsFlailEffect
extends ContinuousRuleModifyingEffectImpl {
    ConquerorsFlailEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "as long as {this} is attached to a creature, your opponents can't cast spells during your turn";
    }

    private ConquerorsFlailEffect(ConquerorsFlailEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public ConquerorsFlailEffect copy() {
        return new ConquerorsFlailEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!game.isActivePlayer(source.getControllerId())) return false;
        if (!game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) return false;
        if (Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getPermanent(arg_0)).map(permanent -> permanent.isCreature(game)).orElse(false) == false) return false;
        return true;
    }
}

