/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetNonlandPermanent;

class ConsumingTideEffect
extends OneShotEffect {
    ConsumingTideEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Each player chooses a nonland permanent they control. Return all nonland permanents not chosen this way to their owners' hands. Then you draw a card for each opponent who has more cards in their hand than you";
    }

    private ConsumingTideEffect(ConsumingTideEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConsumingTideEffect copy() {
        return new ConsumingTideEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashSet<UUID> chosenPermanents = new HashSet<UUID>();
        for (Object playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer((UUID)playerId);
            if (player == null) continue;
            TargetNonlandPermanent target = new TargetNonlandPermanent();
            target.withNotTarget(true);
            player.choose(Outcome.Benefit, (Target)target, source, game);
            UUID permId = target.getFirstTarget();
            if (permId == null) continue;
            chosenPermanents.add(permId);
        }
        HashSet<Permanent> permanentsToHand = new HashSet<Permanent>();
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND, controller.getId(), source, game)) {
            if (chosenPermanents.contains(permanent.getId())) continue;
            permanentsToHand.add(permanent);
        }
        controller.moveCards(permanentsToHand, Zone.HAND, source, game);
        int controllerHandSize = controller.getHand().size();
        int cardsToDraw = 0;
        for (UUID opponentId : game.getOpponents(controller.getId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || opponent.getHand().size() <= controllerHandSize) continue;
            ++cardsToDraw;
        }
        controller.drawCards(cardsToDraw, source, game);
        return true;
    }
}

