/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class ConsumingVaporsEffect
extends OneShotEffect {
    ConsumingVaporsEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Target player sacrifices a creature. You gain life equal to that creature's toughness";
    }

    private ConsumingVaporsEffect(ConsumingVaporsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getTargets().getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
        if (player != null && target.canChoose(player.getId(), source, game)) {
            player.choose(Outcome.Sacrifice, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                int toughness = permanent.getToughness().getValue();
                permanent.sacrifice(source, game);
                game.processAction();
                controller.gainLife(toughness, game, source);
            }
            return true;
        }
        return false;
    }

    public ConsumingVaporsEffect copy() {
        return new ConsumingVaporsEffect(this);
    }
}

