/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ContagionEngineEffect
extends OneShotEffect {
    ContagionEngineEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "put a -1/-1 counter on each creature target player controls";
    }

    private ContagionEngineEffect(ContagionEngineEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            for (Permanent creature : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, targetPlayer.getId(), game)) {
                creature.addCounters(CounterType.M1M1.createInstance(), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }

    public ContagionEngineEffect copy() {
        return new ContagionEngineEffect(this);
    }
}

