/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Pest11GainLifeToken;

class ContainmentBreachEffect
extends OneShotEffect {
    ContainmentBreachEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy target artifact or enchantment. If its mana value is 2 or less, create a 1/1 black and green Pest creature token with \"When this creature dies, you gain 1 life.\"";
    }

    private ContainmentBreachEffect(ContainmentBreachEffect effect) {
        super((OneShotEffect)effect);
    }

    public ContainmentBreachEffect copy() {
        return new ContainmentBreachEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.destroy(source, game, false);
        if (permanent.getManaValue() <= 2) {
            new Pest11GainLifeToken().putOntoBattlefield(1, game, source, source.getControllerId());
        }
        return true;
    }
}

