/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ContainmentConstructEffect
extends OneShotEffect {
    ContainmentConstructEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may exile that card from your graveyard. If you do, you may play that card this turn";
    }

    private ContainmentConstructEffect(ContainmentConstructEffect effect) {
        super((OneShotEffect)effect);
    }

    public ContainmentConstructEffect copy() {
        return new ContainmentConstructEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Card discardedCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        Card containmentConstruct = game.getCard(source.getSourceId());
        if (discardedCard != null && containmentConstruct != null && (controller = game.getPlayer(source.getControllerId())).chooseUse(Outcome.Benefit, "Do you want to exile the discarded card?  You may play it this turn from exile.", source, game)) {
            UUID exileId = CardUtil.getExileZoneId((Game)game, (Ability)source);
            controller.moveCardsToExile(discardedCard, source, game, true, exileId, "Exiled by " + containmentConstruct.getIdName());
            PlayFromNotOwnHandZoneTargetEffect effect = new PlayFromNotOwnHandZoneTargetEffect(Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(discardedCard.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

