/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ContestedGameBallEffect
extends OneShotEffect {
    ContestedGameBallEffect() {
        super(Outcome.GainControl);
        this.staticText = "the attacking player gains control of {this} and untaps it";
    }

    private ContestedGameBallEffect(ContestedGameBallEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player newController = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || newController == null || controller.getId().equals(newController.getId())) {
            return false;
        }
        GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, newController.getId());
        effect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), game));
        game.addEffect((ContinuousEffect)effect, source);
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent != null) {
            sourcePermanent.untap(game);
        }
        return true;
    }

    public ContestedGameBallEffect copy() {
        return new ContestedGameBallEffect(this);
    }
}

