/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ConvincingMirageContinousEffect
extends ContinuousEffectImpl {
    ConvincingMirageContinousEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Neutral);
        this.staticText = "Enchanted land is the chosen type";
    }

    private ConvincingMirageContinousEffect(ConvincingMirageContinousEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ConvincingMirageContinousEffect copy() {
        return new ConvincingMirageContinousEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        SubType choice = SubType.byDescription((String)((String)game.getState().getValue(source.getSourceId().toString() + "BasicLandType")));
        if (choice == null) {
            this.discard();
            return;
        }
        switch (choice) {
            case FOREST: {
                this.dependencyTypes.add(DependencyType.BecomeForest);
                break;
            }
            case PLAINS: {
                this.dependencyTypes.add(DependencyType.BecomePlains);
                break;
            }
            case MOUNTAIN: {
                this.dependencyTypes.add(DependencyType.BecomeMountain);
                break;
            }
            case ISLAND: {
                this.dependencyTypes.add(DependencyType.BecomeIsland);
                break;
            }
            case SWAMP: {
                this.dependencyTypes.add(DependencyType.BecomeSwamp);
            }
        }
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        SubType choice = SubType.byDescription((String)((String)game.getState().getValue(source.getSourceId().toString() + "BasicLandType")));
        if (enchantment == null || enchantment.getAttachedTo() == null || choice == null) {
            return false;
        }
        Permanent land = game.getPermanent(enchantment.getAttachedTo());
        if (land == null) {
            return false;
        }
        land.removeAllSubTypes(game, SubTypeSet.NonBasicLandType);
        land.addSubType(game, new SubType[]{choice});
        land.removeAllAbilities(source.getSourceId(), game);
        switch (choice) {
            case FOREST: {
                land.addAbility((Ability)new GreenManaAbility(), source.getSourceId(), game);
                break;
            }
            case PLAINS: {
                land.addAbility((Ability)new WhiteManaAbility(), source.getSourceId(), game);
                break;
            }
            case MOUNTAIN: {
                land.addAbility((Ability)new RedManaAbility(), source.getSourceId(), game);
                break;
            }
            case ISLAND: {
                land.addAbility((Ability)new BlueManaAbility(), source.getSourceId(), game);
                break;
            }
            case SWAMP: {
                land.addAbility((Ability)new BlackManaAbility(), source.getSourceId(), game);
            }
        }
        return true;
    }
}

