/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.MillCardsTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.DefenderAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.target.Target;
import mage.target.TargetPlayer;

public final class CoralColony
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("creatures you control with defender");
    private static final DynamicValue xValue;
    private static final Hint hint;

    public CoralColony(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{U}");
        this.subtype.add((Object)SubType.WALL);
        this.power = new MageInt(1);
        this.toughness = new MageInt(4);
        this.addAbility((Ability)DefenderAbility.getInstance());
        String ruleText = "target player mills X cards, where X is the number of creatures you control with defender";
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new MillCardsTargetEffect(xValue).setText(ruleText), (Cost)new ManaCostsImpl("{1}{U}"));
        ability.addCost((Cost)new TapSourceCost());
        ability.addTarget((Target)new TargetPlayer());
        this.addAbility(ability.addHint(hint));
    }

    private CoralColony(CoralColony card) {
        super((CardImpl)card);
    }

    public CoralColony copy() {
        return new CoralColony(this);
    }

    static {
        filter.add((Predicate)new AbilityPredicate(DefenderAbility.class));
        xValue = new PermanentsOnBattlefieldCount(filter);
        hint = new ValueHint("Creatures with defender you control", xValue);
    }
}

