/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.Set;
import mage.MageIdentifier;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class CoramTheUndertakerWatcher
extends Watcher {
    private final Set<MageObjectReference> landPlayedForSource = new HashSet<MageObjectReference>();
    private final Set<MageObjectReference> spellCastForSource = new HashSet<MageObjectReference>();
    private final Set<MageObjectReference> cardsAllowedToBePlayedOrCast = new HashSet<MageObjectReference>();

    public CoramTheUndertakerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE) {
            ZoneChangeEvent zce = (ZoneChangeEvent)event;
            if (!Zone.LIBRARY.equals((Object)zce.getFromZone()) || !Zone.GRAVEYARD.equals((Object)zce.getToZone())) {
                return;
            }
            Card card = game.getCard(zce.getTargetId());
            if (card == null) {
                return;
            }
            Card mainCard = card.getMainCard();
            if (game.getState().getZone(mainCard.getId()) != Zone.GRAVEYARD) {
                return;
            }
            this.cardsAllowedToBePlayedOrCast.add(new MageObjectReference((MageObject)mainCard, game));
            return;
        }
        if (event.getApprovingObject() == null || !MageIdentifier.CoramTheUndertakerWatcher.equals((Object)event.getApprovingObject().getApprovingAbility().getIdentifier())) {
            return;
        }
        if (event.getType() == GameEvent.EventType.LAND_PLAYED) {
            this.landPlayedForSource.add(event.getApprovingObject().getApprovingMageObjectReference());
        }
        if (event.getType() == GameEvent.EventType.SPELL_CAST) {
            this.spellCastForSource.add(event.getApprovingObject().getApprovingMageObjectReference());
        }
    }

    public void reset() {
        this.landPlayedForSource.clear();
        this.spellCastForSource.clear();
        this.cardsAllowedToBePlayedOrCast.clear();
        super.reset();
    }

    public boolean cardPutFromGraveyardThisTurn(MageObjectReference mor) {
        return this.cardsAllowedToBePlayedOrCast.contains(mor);
    }

    public boolean landPlayedFromGraveyard(Ability source, Game game) {
        return this.landPlayedForSource.contains(new MageObjectReference(source.getSourceObject(game), game));
    }

    public boolean spellCastFromGraveyard(Ability source, Game game) {
        return this.spellCastForSource.contains(new MageObjectReference(source.getSourceObject(game), game));
    }
}

