/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ZombieMenaceToken;

class CorpseCobbleEffect
extends OneShotEffect {
    CorpseCobbleEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create an X/X blue and black Zombie creature token with menace, where X is the total power of the sacrificed creatures";
    }

    private CorpseCobbleEffect(CorpseCobbleEffect effect) {
        super((OneShotEffect)effect);
    }

    public CorpseCobbleEffect copy() {
        return new CorpseCobbleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            for (Permanent permanent : ((SacrificeTargetCost)cost).getPermanents()) {
                xValue += permanent.getPower().getValue();
            }
        }
        return new ZombieMenaceToken(xValue).putOntoBattlefield(1, game, source, source.getControllerId());
    }
}

