/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CorrosionUpkeepEffect
extends OneShotEffect {
    private static final FilterArtifactPermanent filter = new FilterArtifactPermanent();

    CorrosionUpkeepEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "put a rust counter on each artifact target opponent controls. Then destroy each artifact with mana value less than or equal to the number of rust counters on it. Artifacts destroyed this way can't be regenerated";
    }

    private CorrosionUpkeepEffect(CorrosionUpkeepEffect effect) {
        super((OneShotEffect)effect);
    }

    public CorrosionUpkeepEffect copy() {
        return new CorrosionUpkeepEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (player != null && sourcePermanent != null) {
            Player targetPlayer = game.getPlayer(source.getFirstTarget());
            if (targetPlayer != null) {
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, targetPlayer.getId(), game)) {
                    permanent.addCounters(CounterType.RUST.createInstance(), source.getControllerId(), source, game);
                }
            }
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                if (permanent.getManaValue() > permanent.getCounters(game).getCount(CounterType.RUST)) continue;
                permanent.destroy(source, game, true);
            }
            return true;
        }
        return false;
    }
}

