/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.cards.Card;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.ColoredManaSymbol;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CorruptedGrafstoneManaEffect
extends ManaEffect {
    private final Mana computedMana;

    public CorruptedGrafstoneManaEffect() {
        this.computedMana = new Mana();
        this.staticText = "Choose a color of a card in your graveyard. Add one mana of that color";
    }

    private CorruptedGrafstoneManaEffect(CorruptedGrafstoneManaEffect effect) {
        super((ManaEffect)effect);
        this.computedMana = effect.computedMana.copy();
    }

    public CorruptedGrafstoneManaEffect copy() {
        return new CorruptedGrafstoneManaEffect(this);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netManas = new ArrayList<Mana>();
        Mana types = this.getManaTypesInGraveyard(game, source);
        if (types == null) {
            return null;
        }
        if (types.getBlack() > 0) {
            netManas.add(new Mana(ColoredManaSymbol.B));
        }
        if (types.getRed() > 0) {
            netManas.add(new Mana(ColoredManaSymbol.R));
        }
        if (types.getBlue() > 0) {
            netManas.add(new Mana(ColoredManaSymbol.U));
        }
        if (types.getGreen() > 0) {
            netManas.add(new Mana(ColoredManaSymbol.G));
        }
        if (types.getWhite() > 0) {
            netManas.add(new Mana(ColoredManaSymbol.W));
        }
        return netManas;
    }

    public Mana produceMana(Game game, Ability source) {
        Player player;
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Mana types = this.getManaTypesInGraveyard(game, source);
        ChoiceColor choice = new ChoiceColor(true);
        choice.getChoices().clear();
        choice.setMessage("Pick a mana color");
        if (types.getBlack() > 0) {
            choice.getChoices().add("Black");
        }
        if (types.getRed() > 0) {
            choice.getChoices().add("Red");
        }
        if (types.getBlue() > 0) {
            choice.getChoices().add("Blue");
        }
        if (types.getGreen() > 0) {
            choice.getChoices().add("Green");
        }
        if (types.getWhite() > 0) {
            choice.getChoices().add("White");
        }
        if (!choice.getChoices().isEmpty() && (player = game.getPlayer(source.getControllerId())) != null) {
            if (choice.getChoices().size() == 1) {
                choice.setChoice((String)choice.getChoices().iterator().next());
            } else if (!player.choose(Outcome.PutManaInPool, (Choice)choice, game)) {
                return mana;
            }
            switch (choice.getChoice()) {
                case "Black": {
                    mana.setBlack(1);
                    break;
                }
                case "Blue": {
                    mana.setBlue(1);
                    break;
                }
                case "Red": {
                    mana.setRed(1);
                    break;
                }
                case "Green": {
                    mana.setGreen(1);
                    break;
                }
                case "White": {
                    mana.setWhite(1);
                }
            }
        }
        return mana;
    }

    private Mana getManaTypesInGraveyard(Game game, Ability source) {
        if (game != null && source != null && source.getControllerId() != null) {
            Player controller = game.getPlayer(source.getControllerId());
            Mana types = new Mana();
            if (controller != null) {
                for (Card card : controller.getGraveyard().getCards(game)) {
                    if (card == null) continue;
                    for (ObjectColor color : card.getColor(game).getColors()) {
                        if (color.isWhite()) {
                            types.setWhite(1);
                        }
                        if (color.isBlue()) {
                            types.setBlue(1);
                        }
                        if (color.isBlack()) {
                            types.setBlack(1);
                        }
                        if (color.isRed()) {
                            types.setRed(1);
                        }
                        if (!color.isGreen()) continue;
                        types.setGreen(1);
                    }
                }
                return types;
            }
        }
        return null;
    }
}

