/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CosmicRebirthEffect
extends OneShotEffect {
    CosmicRebirthEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target permanent card in your graveyard. If it has mana value 3 or less, you may put it onto the battlefield. If you don't put it onto the battlefield, put it into your hand";
    }

    private CosmicRebirthEffect(CosmicRebirthEffect effect) {
        super((OneShotEffect)effect);
    }

    public CosmicRebirthEffect copy() {
        return new CosmicRebirthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        return player != null && card != null && player.moveCards(card, card.getManaValue() <= 3 && player.chooseUse(Outcome.PutCardInPlay, "Put it onto the battlefield or your hand?", null, "Battlefield", "Hand", source, game) ? Zone.BATTLEFIELD : Zone.HAND, source, game);
    }
}

