/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class CosmiumCatalystEffect
extends OneShotEffect {
    CosmiumCatalystEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Choose an exiled card used to craft {this} at random. You may cast that card without paying its mana cost.";
    }

    private CosmiumCatalystEffect(CosmiumCatalystEffect effect) {
        super((OneShotEffect)effect);
    }

    public CosmiumCatalystEffect copy() {
        return new CosmiumCatalystEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        MageObject sourceObject = game.getObject(source.getSourceId());
        if (sourceObject == null) {
            return false;
        }
        TargetCardInExile target = new TargetCardInExile(StaticFilters.FILTER_CARD, CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)(game.getState().getZoneChangeCounter(source.getSourceId()) - 2)));
        target.withNotTarget(true);
        target.setRandom(true);
        if (!target.canChoose(controller.getId(), source, game)) {
            return true;
        }
        target.chooseTarget(this.outcome, controller.getId(), source, game);
        Card chosenCard = game.getCard(target.getFirstTarget());
        if (chosenCard != null) {
            CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Card)chosenCard);
        }
        return true;
    }
}

