/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

class CounterbalanceEffect
extends OneShotEffect {
    CounterbalanceEffect() {
        super(Outcome.Neutral);
        this.staticText = "you may reveal the top card of your library. If you do, counter that spell if it has the same mana value as the revealed card";
    }

    private CounterbalanceEffect(CounterbalanceEffect effect) {
        super((OneShotEffect)effect);
    }

    public CounterbalanceEffect copy() {
        return new CounterbalanceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourcePermanent != null && (spell = (Spell)game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source))) != null) {
            Card topcard = controller.getLibrary().getFromTop(game);
            if (topcard != null) {
                CardsImpl cards = new CardsImpl();
                cards.add(topcard);
                controller.revealCards(sourcePermanent.getName(), (Cards)cards, game);
                if (topcard.getManaValue() == spell.getManaValue()) {
                    return game.getStack().counter(spell.getId(), source, game);
                }
            }
            return true;
        }
        return false;
    }
}

